
/*include the glimmix macro*/
%inc 'glimmix.sas' / nosource;

/*folder where the IG prior*/
libname sal 'salamander analysis';

/*read in the salamander data*/
data salamander;
input day fpop$ fnum mpop$ mnum mating season$;
cards;
4	rb	1	rb	1	1	summer
4	rb	2	rb	5	1	summer
4	rb	3	rb	2	1	summer
4	rb	4	rb	4	1	summer
4	rb	5	rb	3	1	summer
4	rb	6	ws	9	1	summer
4	rb	7	ws	8	0	summer
4	rb	8	ws	6	0	summer
4	rb	9	ws	10	0	summer
4	rb	10	ws	7	0	summer
4	ws	1	rb	9	0	summer
4	ws	2	rb	7	0	summer
4	ws	3	rb	8	0	summer
4	ws	4	rb	10	0	summer
4	ws	5	rb	6	0	summer
4	ws	6	ws	5	0	summer
4	ws	7	ws	4	1	summer
4	ws	8	ws	1	1	summer
4	ws	9	ws	3	1	summer
4	ws	10	ws	2	1	summer
8	rb	1	ws	4	1	summer
8	rb	2	ws	5	1	summer
8	rb	3	ws	1	0	summer
8	rb	4	ws	2	1	summer
8	rb	5	ws	3	1	summer
8	rb	6	rb	9	1	summer
8	rb	7	rb	8	0	summer
8	rb	8	rb	6	1	summer
8	rb	9	rb	7	0	summer
8	rb	10	rb	10	0	summer
8	ws	1	ws	9	1	summer
8	ws	2	ws	6	0	summer
8	ws	3	ws	7	0	summer
8	ws	4	ws	10	1	summer
8	ws	5	ws	8	1	summer
8	ws	6	rb	2	0	summer
8	ws	7	rb	1	1	summer
8	ws	8	rb	4	0	summer
8	ws	9	rb	3	1	summer
8	ws	10	rb	5	0	summer
12	rb	1	rb	5	1	summer
12	rb	2	rb	3	1	summer
12	rb	3	rb	1	1	summer
12	rb	4	rb	2	1	summer
12	rb	5	rb	4	1	summer
12	rb	6	ws	10	1	summer
12	rb	7	ws	9	0	summer
12	rb	8	ws	7	0	summer
12	rb	9	ws	8	1	summer
12	rb	10	ws	6	1	summer
12	ws	1	rb	7	1	summer
12	ws	2	rb	9	0	summer
12	ws	3	rb	6	0	summer
12	ws	4	rb	8	1	summer
12	ws	5	rb	10	0	summer
12	ws	6	ws	3	1	summer
12	ws	7	ws	5	1	summer
12	ws	8	ws	2	1	summer
12	ws	9	ws	1	1	summer
12	ws	10	ws	4	0	summer
16	rb	1	ws	1	0	summer
16	rb	2	ws	3	1	summer
16	rb	3	ws	4	1	summer
16	rb	4	ws	5	0	summer
16	rb	5	ws	2	1	summer
16	rb	6	rb	7	0	summer
16	rb	7	rb	9	1	summer
16	rb	8	rb	10	0	summer
16	rb	9	rb	6	1	summer
16	rb	10	rb	8	0	summer
16	ws	1	ws	10	1	summer
16	ws	2	ws	7	1	summer
16	ws	3	ws	9	0	summer
16	ws	4	ws	8	1	summer
16	ws	5	ws	6	0	summer
16	ws	6	rb	4	0	summer
16	ws	7	rb	2	0	summer
16	ws	8	rb	5	0	summer
16	ws	9	rb	1	1	summer
16	ws	10	rb	3	1	summer
20	rb	1	rb	4	1	summer
20	rb	2	rb	1	1	summer
20	rb	3	rb	3	1	summer
20	rb	4	rb	5	1	summer
20	rb	5	rb	2	1	summer
20	rb	6	ws	6	1	summer
20	rb	7	ws	7	0	summer
20	rb	8	ws	10	1	summer
20	rb	9	ws	9	1	summer
20	rb	10	ws	8	1	summer
20	ws	1	rb	10	0	summer
20	ws	2	rb	6	0	summer
20	ws	3	rb	7	0	summer
20	ws	4	rb	9	0	summer
20	ws	5	rb	8	0	summer
20	ws	6	ws	2	0	summer
20	ws	7	ws	1	1	summer
20	ws	8	ws	5	1	summer
20	ws	9	ws	4	1	summer
20	ws	10	ws	3	1	summer
24	rb	1	ws	5	1	summer
24	rb	2	ws	2	1	summer
24	rb	3	ws	3	1	summer
24	rb	4	ws	4	1	summer
24	rb	5	ws	1	1	summer
24	rb	6	rb	8	1	summer
24	rb	7	rb	6	0	summer
24	rb	8	rb	9	1	summer
24	rb	9	rb	10	1	summer
24	rb	10	rb	7	0	summer
24	ws	1	ws	8	1	summer
24	ws	2	ws	10	0	summer
24	ws	3	ws	6	1	summer
24	ws	4	ws	9	1	summer
24	ws	5	ws	7	0	summer
24	ws	6	rb	1	0	summer
24	ws	7	rb	5	1	summer
24	ws	8	rb	3	0	summer
24	ws	9	rb	4	0	summer
24	ws	10	rb	2	0	summer
4	rb	1	rb	1	1	fall1
4	rb	2	rb	5	1	fall1
4	rb	3	rb	2	0	fall1
4	rb	4	rb	4	1	fall1
4	rb	5	rb	3	1	fall1
4	rb	6	ws	9	1	fall1
4	rb	7	ws	8	1	fall1
4	rb	8	ws	6	1	fall1
4	rb	9	ws	10	1	fall1
4	rb	10	ws	7	0	fall1
4	ws	1	rb	9	0	fall1
4	ws	2	rb	7	0	fall1
4	ws	3	rb	8	0	fall1
4	ws	4	rb	10	0	fall1
4	ws	5	rb	6	0	fall1
4	ws	6	ws	5	1	fall1
4	ws	7	ws	4	1	fall1
4	ws	8	ws	1	0	fall1
4	ws	9	ws	3	1	fall1
4	ws	10	ws	2	1	fall1
8	rb	1	ws	4	0	fall1
8	rb	2	ws	5	1	fall1
8	rb	3	ws	1	1	fall1
8	rb	4	ws	2	0	fall1
8	rb	5	ws	3	0	fall1
8	rb	6	rb	9	1	fall1
8	rb	7	rb	8	1	fall1
8	rb	8	rb	6	0	fall1
8	rb	9	rb	7	1	fall1
8	rb	10	rb	10	0	fall1
8	ws	1	ws	9	1	fall1
8	ws	2	ws	6	1	fall1
8	ws	3	ws	7	1	fall1
8	ws	4	ws	10	0	fall1
8	ws	5	ws	8	0	fall1
8	ws	6	rb	2	0	fall1
8	ws	7	rb	1	0	fall1
8	ws	8	rb	4	0	fall1
8	ws	9	rb	3	1	fall1
8	ws	10	rb	5	0	fall1
12	rb	1	rb	5	1	fall1
12	rb	2	rb	3	1	fall1
12	rb	3	rb	1	1	fall1
12	rb	4	rb	2	0	fall1
12	rb	5	rb	4	1	fall1
12	rb	6	ws	10	1	fall1
12	rb	7	ws	9	0	fall1
12	rb	8	ws	7	0	fall1
12	rb	9	ws	8	1	fall1
12	rb	10	ws	6	1	fall1
12	ws	1	rb	7	0	fall1
12	ws	2	rb	9	0	fall1
12	ws	3	rb	6	0	fall1
12	ws	4	rb	8	1	fall1
12	ws	5	rb	10	0	fall1
12	ws	6	ws	3	1	fall1
12	ws	7	ws	5	1	fall1
12	ws	8	ws	2	0	fall1
12	ws	9	ws	1	1	fall1
12	ws	10	ws	4	1	fall1
16	rb	1	ws	1	0	fall1
16	rb	2	ws	3	0	fall1
16	rb	3	ws	4	1	fall1
16	rb	4	ws	5	0	fall1
16	rb	5	ws	2	0	fall1
16	rb	6	rb	7	0	fall1
16	rb	7	rb	9	1	fall1
16	rb	8	rb	10	0	fall1
16	rb	9	rb	6	1	fall1
16	rb	10	rb	8	1	fall1
16	ws	1	ws	10	0	fall1
16	ws	2	ws	7	0	fall1
16	ws	3	ws	9	1	fall1
16	ws	4	ws	8	1	fall1
16	ws	5	ws	6	0	fall1
16	ws	6	rb	4	1	fall1
16	ws	7	rb	2	0	fall1
16	ws	8	rb	5	0	fall1
16	ws	9	rb	1	1	fall1
16	ws	10	rb	3	1	fall1
20	rb	1	rb	4	1	fall1
20	rb	2	rb	1	0	fall1
20	rb	3	rb	3	1	fall1
20	rb	4	rb	5	0	fall1
20	rb	5	rb	2	0	fall1
20	rb	6	ws	6	0	fall1
20	rb	7	ws	7	0	fall1
20	rb	8	ws	10	1	fall1
20	rb	9	ws	9	0	fall1
20	rb	10	ws	8	1	fall1
20	ws	1	rb	10	0	fall1
20	ws	2	rb	6	0	fall1
20	ws	3	rb	7	0	fall1
20	ws	4	rb	9	0	fall1
20	ws	5	rb	8	0	fall1
20	ws	6	ws	2	1	fall1
20	ws	7	ws	1	0	fall1
20	ws	8	ws	5	0	fall1
20	ws	9	ws	4	1	fall1
20	ws	10	ws	3	1	fall1
24	rb	1	ws	5	0	fall1
24	rb	2	ws	2	1	fall1
24	rb	3	ws	3	1	fall1
24	rb	4	ws	4	0	fall1
24	rb	5	ws	1	0	fall1
24	rb	6	rb	8	0	fall1
24	rb	7	rb	6	1	fall1
24	rb	8	rb	9	0	fall1
24	rb	9	rb	10	1	fall1
24	rb	10	rb	7	0	fall1
24	ws	1	ws	8	1	fall1
24	ws	2	ws	10	1	fall1
24	ws	3	ws	6	1	fall1
24	ws	4	ws	9	1	fall1
24	ws	5	ws	7	0	fall1
24	ws	6	rb	1	1	fall1
24	ws	7	rb	5	0	fall1
24	ws	8	rb	3	0	fall1
24	ws	9	rb	4	1	fall1
24	ws	10	rb	2	0	fall1
4	rb	1	rb	1	1	fall2 
4	rb	2	rb	5	0	fall2 
4	rb	3	rb	2	1	fall2 
4	rb	4	rb	4	1	fall2 
4	rb	5	rb	3	0	fall2 
4	rb	6	ws	9	0	fall2 
4	rb	7	ws	8	0	fall2 
4	rb	8	ws	6	1	fall2 
4	rb	9	ws	10	0	fall2 
4	rb	10	ws	7	0	fall2 
4	ws	1	rb	9	0	fall2 
4	ws	2	rb	7	0	fall2 
4	ws	3	rb	8	1	fall2 
4	ws	4	rb	10	1	fall2 
4	ws	5	rb	6	0	fall2 
4	ws	6	ws	5	0	fall2 
4	ws	7	ws	4	1	fall2 
4	ws	8	ws	1	0	fall2 
4	ws	9	ws	3	1	fall2 
4	ws	10	ws	2	0	fall2 
8	rb	1	ws	4	1	fall2 
8	rb	2	ws	5	0	fall2 
8	rb	3	ws	1	1	fall2 
8	rb	4	ws	2	0	fall2 
8	rb	5	ws	3	1	fall2 
8	rb	6	rb	9	1	fall2 
8	rb	7	rb	8	1	fall2 
8	rb	8	rb	6	1	fall2 
8	rb	9	rb	7	0	fall2 
8	rb	10	rb	10	1	fall2 
8	ws	1	ws	9	0	fall2 
8	ws	2	ws	6	1	fall2 
8	ws	3	ws	7	0	fall2 
8	ws	4	ws	10	1	fall2 
8	ws	5	ws	8	1	fall2 
8	ws	6	rb	2	0	fall2 
8	ws	7	rb	1	0	fall2 
8	ws	8	rb	4	0	fall2 
8	ws	9	rb	3	0	fall2 
8	ws	10	rb	5	0	fall2 
12	rb	1	rb	5	1	fall2 
12	rb	2	rb	3	0	fall2 
12	rb	3	rb	1	1	fall2 
12	rb	4	rb	2	1	fall2 
12	rb	5	rb	4	1	fall2 
12	rb	6	ws	10	1	fall2 
12	rb	7	ws	9	0	fall2 
12	rb	8	ws	7	1	fall2 
12	rb	9	ws	8	1	fall2 
12	rb	10	ws	6	1	fall2 
12	ws	1	rb	7	0	fall2 
12	ws	2	rb	9	0	fall2 
12	ws	3	rb	6	1	fall2 
12	ws	4	rb	8	1	fall2 
12	ws	5	rb	10	1	fall2 
12	ws	6	ws	3	1	fall2 
12	ws	7	ws	5	1	fall2 
12	ws	8	ws	2	1	fall2 
12	ws	9	ws	1	0	fall2 
12	ws	10	ws	4	1	fall2 
16	rb	1	ws	1	0	fall2 
16	rb	2	ws	3	1	fall2 
16	rb	3	ws	4	0	fall2 
16	rb	4	ws	5	1	fall2 
16	rb	5	ws	2	0	fall2 
16	rb	6	rb	7	1	fall2 
16	rb	7	rb	9	0	fall2 
16	rb	8	rb	10	1	fall2 
16	rb	9	rb	6	0	fall2 
16	rb	10	rb	8	1	fall2 
16	ws	1	ws	10	1	fall2 
16	ws	2	ws	7	1	fall2 
16	ws	3	ws	9	0	fall2 
16	ws	4	ws	8	0	fall2 
16	ws	5	ws	6	1	fall2 
16	ws	6	rb	4	0	fall2 
16	ws	7	rb	2	0	fall2 
16	ws	8	rb	5	0	fall2 
16	ws	9	rb	1	0	fall2 
16	ws	10	rb	3	0	fall2 
20	rb	1	rb	4	1	fall2 
20	rb	2	rb	1	0	fall2 
20	rb	3	rb	3	1	fall2 
20	rb	4	rb	5	0	fall2 
20	rb	5	rb	2	1	fall2 
20	rb	6	ws	6	1	fall2 
20	rb	7	ws	7	0	fall2 
20	rb	8	ws	10	1	fall2 
20	rb	9	ws	9	1	fall2 
20	rb	10	ws	8	1	fall2 
20	ws	1	rb	10	0	fall2 
20	ws	2	rb	6	0	fall2 
20	ws	3	rb	7	0	fall2 
20	ws	4	rb	9	0	fall2 
20	ws	5	rb	8	0	fall2 
20	ws	6	ws	2	0	fall2 
20	ws	7	ws	1	0	fall2 
20	ws	8	ws	5	1	fall2 
20	ws	9	ws	4	1	fall2 
20	ws	10	ws	3	1	fall2 
24	rb	1	ws	5	1	fall2 
24	rb	2	ws	2	0	fall2 
24	rb	3	ws	3	1	fall2 
24	rb	4	ws	4	0	fall2 
24	rb	5	ws	1	0	fall2 
24	rb	6	rb	8	1	fall2 
24	rb	7	rb	6	0	fall2 
24	rb	8	rb	9	0	fall2 
24	rb	9	rb	10	1	fall2 
24	rb	10	rb	7	1	fall2 
24	ws	1	ws	8	1	fall2 
24	ws	2	ws	10	1	fall2 
24	ws	3	ws	6	1	fall2 
24	ws	4	ws	9	0	fall2 
24	ws	5	ws	7	1	fall2 
24	ws	6	rb	1	0	fall2 
24	ws	7	rb	5	0	fall2 
24	ws	8	rb	3	0	fall2 
24	ws	9	rb	4	0	fall2 
24	ws	10	rb	2	0	fall2 
;
run;

data salamander;
set salamander;
if fpop='ws' then ws_fem=1;else ws_fem=0;
if mpop='ws' then ws_male=1;else ws_male=0;
if season='summer' then time=1;if season='fall1' then time=2;
if season='fall2' then time=3;
run;

proc format;
value form
1='a:ws'
0='b:rs'
;
run;

/*macro that performs the hybrid Bayesian Laplacian analysis for the salamander data:
input nit indicates the number of iterations performed by the Bayesian computation and the
IGprior contains the IG prior*/

%macro hybrid_laplace(nit=, IGprior=);

%global mean_fem mean_male tau2_fem tau2_male;

/*obtain the approximated linear mixed model*/
%glimmix(data=salamander, 
  stmts=%str( class ws_fem fnum ws_male mnum time;
        model mating = ws_fem|ws_male;)
				   random ws_fem*fnum*time ws_male*mnum*time/g solution ; 
parms (1) (1) (1)/hold=3;
				   format ws_fem ws_male form.;
   %str(  make 'g' out=g1;
        ),
        options=noprint, error=binomial
             )
      run;

data covariance;set _cov;
 if covparm='ws_fem*fnum*time' then call symput('tau2_fem', left(estimate));
 if covparm='ws_male*mnum*time' then call symput('tau2_male', left(estimate)); 
run;

data pdata;	set sal.&IGprior;
run;

ods listing close;
proc mixed data=_ds;
class ws_fem fnum ws_male mnum time; 
   model _z = ws_fem|ws_male ;                               
   random   ws_fem*fnum*time ws_male*mnum*time/g;  
   parms (&tau2_fem) (&tau2_male) (1)/hold=3;/*assume as starting values for the proc mixed
   the PQL variance components*/;
   weight _w;  
   prior data=pdata/out=post alg=rwc nsample=&nit;	
run;   
proc univariate data=post;
var covp1 covp2 ;
ods output basicmeasures=bayesian;
run;

ods listing;


proc print data=bayesian;run; 
data bayesian;set bayesian;
     if varname='covp1' then do;
      if locmeasure='Mean' then call symput('mean_fem', left(locvalue));	
      if varmeasure='Variance' then call symput('var_fem', left(varvalue));
	                        end;
	 if varname='covp2' then do;
       if locmeasure='Mean' then call symput('mean_male', left(locvalue));
       if varmeasure='Variance' then  call symput('var_male', left(varvalue));
	                        end;	                                  
run;

/*perform the Laplacian approximation using the Bayesian estimates for the variance components
obtained above*/
proc glimmix data=salamander method=laplace;
 class ws_fem fnum ws_male mnum time;
 model mating(event='1') = ws_fem|ws_male / dist=binary solution;
 random WS_FEM*FNUM*TIME WS_MALE*MNUM*TIME;	
 parms (&mean_fem) (&mean_male)/noiter;
 format ws_fem ws_male form.;
 ods output parameterestimates=_soln covparms=_cov ;
run;

%mend hybrid_laplace;

%hybrid_laplace(nit=10000,IGprior=igparameters01);
